 ; Ŀ
 ;   Halon.lsp - update blocks based on a directory-specific config file.  
 ;   Copyright 2003, 2004, 2005, 2006 by Rocket Software Ltd.              
 ;   Putting out fires isn't as difficult as recognizing them.             
 ;                                                                         
 ; 

 ; Ŀ
 ;   Instructions.                                                         
 ; Ĵ
 ;   Halon reads information into blocks from the data file Jobdata.txt    
 ;   which is located in the directory containing the current drawing.     
 ;   If it isn't found then nothing is changed.                            
 ;                                                                         
 ;   Jobdata.txt is divided into sections, each of which contains data     
 ;   for one block (by name).                                              
 ;                                                                         
 ;   The first line in each section is composed of the word Block and      
 ;   the name of a block to update, separated by a vertical bar:           
 ;   Block  |  A_Block_Name                                                
 ;   Block names can use wild cards - See the Autocad Customization Guide. 
 ;                                                                         
 ;   Lines up to the next block name line (or the end of the file)         
 ;   describe the attributes to be changed and the method.                 
 ;                                                                         
 ;   The first element of each line is either the name of an attribute     
 ;   or its position in the block.                                         
 ;   The remaining elements describe what to do to the attribute:          
 ;   1. The second element is ##, which empties the attribute.             
 ;   2. The second element is a string, which replaces the current         
 ;      attribute value.                                                   
 ;   3. There are two elements after the attribute name string, both       
 ;      strings.  Every occurrence of the first string in the attribute    
 ;      is replaced with the second.                                       
 ;   4. The second element is #n, each value for n representing a type     
 ;      of value to put into the attribute.                                
 ;      #0  The time and date: August the 27th, 1997, 12:34am              
 ;      #1  The date: 95.04.16                                             
 ;      #2  The time in 12 hour format: 12:23pm                            
 ;      #3  The time in 24 hour format: 20:25                              
 ;      #4  The date and time in 12 hour format: 95.04.16 12:23pm          
 ;      #5  The date and time in 24 hour format: 95.04.16 21:09            
 ;      #6  (or #name) The drawing name without the path.                  
 ;      #7  (or #npath) The drawing name with the path.                    
 ;      #8  The date in after-the-turn-of-the-century format: 2004.06.03.  
 ;      #9  (or #scale) The scale of the current block: 1:x.               
 ;      #10 The date and time in #0 format and the path and filename.      
 ;      #11 (or #xnames) The names of all xrefs in the drawing.            
 ;                                                                         
 ;   Examples:                                                             
 ;                                                                         
 ;   An attribute name and the replacement string.                         
 ;   Attname | String                                                      
 ;   An attribute name and two strings - each occurrence of the first      
 ;   string in the attribute value is replaced with the second.            
 ;   Attname | Oldstring | Newstring                                       
 ;   An attribute position and #6 - replace the attribute value with the   
 ;   filename without the path.                                            
 ;   16 | #6                                                               
 ;   An attribute name and ## - erase the value in this attribute.         
 ;   Attname | ##                                                          
 ;                                                                         
 ;   Everything after a semicolon is ignored, so you can add comments to   
 ;   the end of lines, or data can be saved until it is needed.            
 ; 

 ; Ŀ
 ;   Halon.                                                                
 ;   (Defined at the beginning so that all subroutines are local and       
 ;   thus safe from being redefined.)                                      
 ; 
 (DEFUN C:HALON (/ chug gfcteg gnash nopath patho phath splat thrat dat0 dat1
                   dat2 dat3 dat4 dat5 d8 ss slan fnam joblst blnam)

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen oldlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Climb - find a file by climbing the directory tree.                   
 ;   Arguments: Fnam, a file name without path.                            
 ;              Path, if true and the file isn't found in the local tree,  
 ;              do a findfile search for it, i.e. the entire acad path.    
 ;   Calls Dstep.                                                          
 ;   Returns a filename with path string or nil.                           
 ; 
 (DEFUN CLIMB (fnam path / prefa fila)
 ; Ŀ
 ;   Find out where we are, windows being unclear on the concept.          
 ; 
  (setq prefa (getvar "dwgprefix"))
 ; Ŀ
 ;   Step up until find the file or run out of path.                       
 ; 
  (while (and (/= prefa "")
              (not (setq fila (findfile (strcat prefa fnam)))))
         (setq prefa (dstep prefa)))
 ; Ŀ
 ;   If the file wasn't in the current tree, search the whole acad path.   
 ; 
  (if (and (null fila) path)
      (setq fila (findfile fnam)))
 fila)
 ; Ŀ
 ;   Climb end.                                                            
 ; 

 ; Ŀ
 ;   Contx - Find all referenced xref definitions in the block tables.     
 ;   Takes no arguments.                                                   
 ;   Returns a list of lists: ((Blockname Filename)...)                    
 ; 
 (DEFUN CONTX (/ rew bldat sevnt namlst)
  (setq rew t)
  (while (setq bldat (tblnext "block" rew))
         (setq rew ())
         (setq sevnt (cdr (assoc 70 bldat)))
         (if (and (= 4 (logand 4 sevnt)) (= 32 (logand 32 sevnt)))
             (setq namlst (append namlst (list (list (cdr (assoc 2 bldat))
                                                   (cdr (assoc 1 bldat))))))))
 namlst)
 ; Ŀ
 ;   Contx end.                                                            
 ; 

 ; Ŀ
 ;   Dstep - remove the last level from a path.                            
 ;   Arguments: Stra, a path string.                                       
 ;   Returns a truncated path or "".                                       
 ; 
 (DEFUN DSTEP (stra / pos)
 ; Ŀ
 ;   The last character will probably be a backslash, therefore remove     
 ;   it so that it doesn't stop the loop.                                  
 ; 
  (setq pos (strlen stra))
  (if (and (/= pos 0)
           (member (substr stra pos 1) '("/" "\\")))
      (setq stra (substr stra 1 (1- pos))))
 ; Ŀ
 ;   Remove the next step.                                                 
 ; 
  (setq pos (strlen stra))
  (while (and (/= pos 0)
              (not (member (substr stra pos 1) '("/" "\\"))))
         (setq pos (1- pos)))
  (setq stra (substr stra 1 pos))
 stra)
 ; Ŀ
 ;   Dstep end.                                                            
 ; 

 ; Ŀ
 ;   Gfcteg - read the configuration file into a list.                     
 ;   Takes one argument, the config file name.                             
 ;   Removes comments and leading and trailing spaces.                     
 ;   Returns the configuration list.                                       
 ; 
 (DEFUN GFCTEG (fn / str len stop cfglst sub strlst blnam malist)
 ; Ŀ
 ;   Open the data file and make the configuration list.                   
 ; 
  (if (setq fn (open fn "r"))
      (progn
 ; Ŀ
 ;   While there are lines in the file, process them.                      
 ; 
           (while (and (null stop) (setq str (read-line fn)))
 ; Ŀ
 ;   Kill leading spaces.                                                  
 ; 
                  (while (= (substr str 1 1) " ")
                         (setq str (substr str 2)))
 ; Ŀ
 ;   If the line isn't a comment or empty, proceed.                        
 ; 
                  (if (and (/= (substr str 1 1) ";")
                           (/= str ""))
                      (progn
 ; Ŀ
 ;   Split at semicolons (if any), ditch all but the first substring.      
 ; 
                           (setq str (car (splat ";" str)))
 ; Ŀ
 ;   Ditch trailing spaces.                                                
 ; 
                           (while (= (substr str (setq len (strlen str))) " ")
                                  (setq str (substr str 1 (1- len))))
 ; Ŀ
 ;   Split at separator characters (tentatively |), make into a list.      
 ; 
                           (setq sub (splat "|" str))
 ; Ŀ
 ;   Capitalize the first string in sub, make into a dotted pair.          
 ; 
                           (setq sub (cons (strcase (car sub)) (cdr sub)))
 ; Ŀ
 ;   If the current sublist contains the block name then save it for       
 ;   later.  Otherwise add the sublist to the master list.                 
 ;   Also want to start a new block sublist here when a block name marker  
 ;   is found.                                                             
 ; 
                           (if (= (strcase (car sub)) "BLOCK")
                               (progn
                                    (setq malist (cons (cons blnam cfglst)
                                                        malist))
                                    (setq blnam (cadr sub))
                                    (setq cfglst ()))
                               (setq cfglst (cons sub cfglst))))))
 ; Ŀ
 ;   Are now out of the loop, so add any remaining cfglst data to malist.  
 ; 
           (setq malist (cons (cons blnam cfglst) malist))
 ; Ŀ
 ;   Close the data file, return the data list.                            
 ; 
           (close fn)))
 malist)
 ; Ŀ
 ;   Gfcteg end.                                                           
 ; 

 ; Ŀ
 ;   Gnash - replace any strings "#n" in a list and sublists with the      
 ;   number n.                                                             
 ;   Arguments: Thing, an atom or list.                                    
 ;   Returns the same thing, but with dashes.                              
 ;   Calls only itself.  (Recursive.)                                      
 ; 
 (DEFUN GNASH (thing / typ thtoo)
  (setq typ (type thing))
  (cond ((and (= typ 'STR)
              (> (strlen thing) 1)
              (= (substr thing 1 1) "#")
              (= (type (setq thtoo (read (substr thing 2)))) 'INT))
         (setq thing thtoo))
        ((= typ 'LIST)
         (setq thing (mapcar 'gnash thing))))
 thing)
 ; Ŀ
 ;   Gnash end.                                                            
 ; 

 ; Ŀ
 ;   Nopath - returns the drawing name without the extension.              
 ; 
 (DEFUN NOPATH ( / dwgnam)
  (setq dwgnam (strcase (getvar "dwgname")))
  (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
      (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
  dwgnam)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   Patho - returns the drawing name with the path and extension.         
 ; 
 (DEFUN PATHO ()
  (strcase (strcat (getvar "dwgprefix") (getvar "dwgname"))))
 ; Ŀ
 ;   Patho end.                                                            
 ; 

 ; Ŀ
 ;   Phath - correct the case of a text string, typically a path.          
 ;   If a path, each directory name is capitalized, if a string the first  
 ;   character is capitalized.  All other characters are in lower case.    
 ;   Takes one argument, a string, which it returns, corrected.            
 ; 
 (DEFUN PHATH (str / strlst sub newstr)
  (setq strlst (splat "\\" str))
  (while (setq sub (car strlst))
         (setq strlst (cdr strlst))
         (setq sub (strcat (strcase (substr sub 1 1))
                           (strcase (substr sub 2) t)))
         (if (null newstr)
             (setq newstr sub)
             (setq newstr (strcat newstr "\\" sub))))
 newstr)
 ; Ŀ
 ;   Phath end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Thrat - Update the attributes in a block.                  
 ;   Arguments: Enam, the entity name of the block insertion to modify.    
 ;              Sub, the configuration list option part which names        
 ;                   or gives the positions of attributes and says what    
 ;                   is to be done with them.                              
 ;   Returns nothing.                                                      
 ;   Calls Chug (sometimes).                                               
 ; 
 (DEFUN THRAT (enam sub / num esav scal entt enam tagg curlis asoc1 altr 2nd)
  (setq num 0)
  (setq esav enam)
 ; Ŀ
 ;   Extract the scale from the block in question.                         
 ; 
  (setq scal (cdr (assoc 41 (entget enam))))
 ; Ŀ
 ;   Try to allow for strange rounding errors.                             
 ; 
  (setq scalp (fix (+ scal 0.0000001)))
 ; Ŀ
 ;   If the scale has no decimal place, convert it to an integer,          
 ;   otherwise use it as a real.                                           
 ; 
  (if (equal scal scalp 0.0000001)
      (progn
           (setq scal scalp)
           (setq scal (strcat "1:" (itoa scal))))
      (setq scal (strcat "1:" (rtos scal 2 2))))
 ; Ŀ
 ;   Process each attribute.                                               
 ; 
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
                                                                   "SEQEND")
         (setq num (1+ num))   ; attribute position counter
         (setq tagg (strcase (cdr (assoc 2 entt))))
 ; Ŀ
 ;   See if an association sublist exists in the configuration list        
 ;   either for the attribute tag or position number.                      
 ;   Notes: 1. If there are both a sublist for an attribute by tag name    
 ;             and one for the same attribute by position then the name    
 ;             sublist will be used.                                       
 ;          2. If there are multiple sublists referring to the same        
 ;             attribute by either name or position, all those after       
 ;             the first will be ignored.                                  
 ; 
         (setq curlis (assoc tagg sub))
 ; Ŀ
 ;   If there was no association sublist exists for the attribute tag      
 ;   then try the position number.                                         
 ;   Note that it will have been read into the list as a string and must   
 ;   be searched for this way.                                             
 ;   This may cause trouble if the attributes are numbered rather than     
 ;   named, and they aren't in the right positions... this will probably   
 ;   be vanishingly rare.                                                  
 ; 
         (if (null curlis)
             (setq curlis (assoc (itoa num) sub)))
 ; Ŀ
 ;   Now decide what to do to the attribute.                               
 ;   There were three elements in the matching configuration sublist.      
 ; 
         (cond ((= (length curlis) 3)
                (setq asoc1 (assoc 1 entt))
                (setq altr (car (chug (nth 1 curlis) (nth 2 curlis)
                                                                (cdr asoc1))))
                (entmod (subst (cons 1 altr) asoc1 entt)))
 ; Ŀ
 ;   The second config sublist element was an integer.                     
 ; 
               ((= (type (setq 2nd (cadr curlis))) 'INT)
                (setq newval ())
                (cond ((= 2nd 0)
                       (setq newval (dat0)))
                      ((= 2nd 1)
                       (setq newval (dat1)))
                      ((= 2nd 2)
                       (setq newval (dat2)))
                      ((= 2nd 3)
                       (setq newval (dat3)))
                      ((= 2nd 4)
                       (setq newval (dat4)))
                      ((= 2nd 5)
                       (setq newval (dat5)))
                      ((= 2nd 6)
                       (setq newval (nopath)))
                      ((= 2nd 7)
                       (setq newval (patho)))
                      ((= 2nd 8)
                       (setq newval (d8)))
                      ((= 2nd 9)
                       (setq newval scal))
                      ((= 2nd 10)
                       (setq newval (dat10)))
                      ((= 2nd 11)
                       (setq newval (xn))))
                (if newval
                    (entmod (subst (cons 1 newval) (assoc 1 entt) entt))
                    (prompt (strcat "\nUnrecognized code in JobData.txt: #"
                                    (itoa 2nd)))))
 ; Ŀ
 ;   The second config sublist element was "##".                           
 ; 
               ((= (cadr curlis) "##")
                (entmod (subst (cons 1 "") (assoc 1 entt) entt)))
 ; Ŀ
 ;   The second config sublist element was "#Name".                        
 ; 
               ((and curlis (= (strcase (cadr curlis) t) "#name"))
                (entmod (subst (cons 1 (nopath)) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The second config sublist element was "#Npath".                       
 ; 
               ((and curlis (= (strcase (cadr curlis) t) "#npath"))
                (entmod (subst (cons 1 (patho)) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The second config sublist element was "#Xnames".                      
 ; 
               ((and curlis (= (strcase (cadr curlis) t) "#xnames"))
                (entmod (subst (cons 1 (xn)) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The second config sublist element was "#Scale".                       
 ; 
               ((and curlis (= (strcase (cadr curlis) t) "#scale"))
                (entmod (subst (cons 1 scal) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The second config sublist element was a string.                       
 ; 
               ((= (type (setq 2nd (cadr curlis))) 'STR)
                (entmod (subst (cons 1 2nd) (assoc 1 entt) entt)))))
 (princ))
 ; Ŀ
 ;   Subroutine Thrat end.                                                 
 ; 

 ; Ŀ
 ;   Dat0: subroutine - make a string containing the time and date in      
 ;   long format - August the 27th, 1997, 12:34am.                         
 ; 
 (DEFUN DAT0 (/ wkday month date year day hour min ampm suff)
  (setq wkday (menucmd "M=$(edtime,$(getvar,date),dddd)"))
  (setq month (menucmd "M=$(edtime,$(getvar,date),month)"))
  (setq date (rtos (getvar "cdate") 2 12))
  (setq year (substr date 1 4))
  (setq day (substr date 7 2))
  (setq hour (read (substr date 10 2)))
  (if (> hour 12)
      (progn
           (setq hour (itoa (- hour 12)))
           (setq ampm "pm"))
      (progn
           (setq hour (itoa hour))
           (setq ampm "am")))
  (setq min (substr date 12 2))
  (cond ((or (= day "1") (= day "21") (= day "31"))
         (setq suff "st"))
        ((or (= day "2") (= day "22"))
         (setq suff "nd"))
        ((or (= day "3") (= day "23"))
         (setq suff "rd"))
        (T (setq suff "th")))
  (setq date (strcat wkday ", " month " the " day suff ", " year
                     ", " hour ":" min ampm)))
 ; Ŀ
 ;   Dat0 end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Dat1 - make a date string in 95.04.16 format.              
 ; 
 (DEFUN DAT1 (/ dd yy mm da)
  (setq dd (rtos (fix (getvar "cdate"))))
  (setq yy (substr dd 3 2) mm (substr dd 5 2) da (substr dd 7 2))
  (setq dd (strcat yy "." mm "." da)))
 ; Ŀ
 ;   Dat1 end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Dat2 - make a time string in 12 hour format: 12:23pm       
 ; 
 (DEFUN DAT2 (/ date hourp min hour ampm)
  (setq date (rtos (getvar "cdate") 2 12))
  (setq hourp (read (substr date 10 2)))
  (setq min (substr date 12 2))
  (if (> hourp 12)
      (setq hour (itoa (- hourp 12)))
      (setq hour (itoa hourp)))
  (if (and (>= hourp 12)
           (> (read min) 0))
      (setq ampm "pm")
      (setq ampm "am"))
  (strcat hour ":" min ampm))
 ; Ŀ
 ;   Dat2 end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Dat3 - make a time string in 24 hour format: 20:25         
 ; 
 (DEFUN DAT3 (/ date)
  (setq date (rtos (getvar "cdate") 2 12))
  (strcat (substr date 10 2) ":" (substr date 12 2)))
 ; Ŀ
 ;   Dat3 end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Dat4 - make a date and time string in 12 hour format:      
 ;   95.04.16 12:23pm                                                      
 ; 
 (DEFUN DAT4 ()
  (strcat (dat1) " " (dat2)))
 ; Ŀ
 ;   Dat4 end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Dat5 - make a date and time string in 24 hour format:      
 ;   95.04.16 21:09                                                        
 ; 
 (DEFUN DAT5 ()
  (strcat (dat1) " " (dat3)))
 ; Ŀ
 ;   Dat5 end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine D8 - make a date string in 2003.04.16 format.              
 ; 
 (DEFUN D8 (/ dd yy mm da)
  (setq dd (rtos (fix (getvar "cdate"))))
  (setq yy (substr dd 1 4) mm (substr dd 5 2) da (substr dd 7 2))
  (setq dd (strcat yy "." mm "." da)))
 ; Ŀ
 ;   D8 end.                                                               
 ; 

 ; Ŀ
 ;   Dat10: subroutine - make a string containing the time and date in     
 ;   long format - August the 27th, 1997, 12:34am, and the path and        
 ;   filename.                                                             
 ; 
 (DEFUN DAT10 ()
  (strcat (dat0) "  " (patho)))
 ; Ŀ
 ;   Dat10 end filename.                                                   
 ; 

 ; Ŀ
 ;   Xn - make a string listing all xrefs.                                 
 ;   Copyright 1997, 1998, 2000, 2006 by Rocket Software Ltd.              
 ;   Calls Contx, returns a string.                                        
 ; 
 (DEFUN XN (/ xlst xstr sub)
  (setq xlst (contx))
  (while (and xlst (setq sub (caar xlst)))
         (setq sub (strcase sub))
         (setq xlst (cdr xlst))
         (if xstr
            (setq xstr (strcat xstr ", " sub))
            (setq xstr sub)))
  (if xstr (setq xstr (strcat "Xref"
                              (if (= (length xlst) 1) ": " "s: ")
                               xstr))
           (setq xstr "No Xrefs."))
 xstr)
 ; Ŀ
 ;   Xn end.                                                               
 ; 

 ; Ŀ
 ;   Halon.                                                                
 ; 
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Call climb to see if the data file is available in the local tree,    
 ;   if so then read it into a list.  Don't search globally if it can't    
 ;   be found locally.                                                     
 ; 
  (if (setq fnam (climb "jobdata.txt" ()))
      (progn
 ; Ŀ
 ;   Indicate which Halon.dat file was used.                               
 ; 
           (prompt (strcat "\nUsing Block Update Data File: " fnam "\n"))
           (setq joblst (gfcteg fnam))
 ; Ŀ
 ;   Convert #n substrings in joblst to the integer n.                     
 ;   (This doesn't affect attribute position numbers.)                     
 ; 
           (setq joblst (gnash joblst))
 ; Ŀ
 ;   While there are sublists in the master configuration list...          
 ; 
           (while (and (setq sub (car joblst)) ; 1st sublist = 1 block etc.
                       (setq bnam (nth 0 sub))
                       (= (type bnam) 'STR))
                  (setq joblst (cdr joblst))   ; remove 1st sublist from master
 ; Ŀ
 ;   Now have Bnam, the name of the block to update and Sub, the           
 ;   configuration list.                                                   
 ;   Knock the block name off Sub.                                         
 ; 
                  (setq sub (cdr sub))
 ; Ŀ
 ;   Search for insertions of block Bnam.                                  
 ; 
                  (setq ss (ssget "X" (list (cons 2 bnam))))
                  (setq num 0)
 ; Ŀ
 ;   While there are Bnam insertions.                                      
 ; 
                  (while (and ss (setq enam (ssname ss num)))
                         (setq num (1+ num))
 ; Ŀ
 ;   Call Thrat to modify them.                                            
 ; 
                         (thrat enam sub)
                         (entupd enam)))))
 (princ))